import os, subprocess, shlex, tempfile

AFTER_EFFECTS_APP = "Adobe After Effects 2025"

# Paths
PROJECT   = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/ScoringAnimations4.aep"
CSV_PATH  = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/teams_rgb_correct.csv"
JSX_BATCH = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/batch_ScoringAnimations4-FG.jsx"

# AE / template settings
COMP        = "FG Comp"          # composition to render
ANIM_NAME   = "_FG_3_6"
RS_TEMPLATE = "Best Settings"
OM_TEMPLATE = "PNG Sequence"     # must be a PNG-sequence template that numbers from 0000

# Output
OUTDIR        = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/FG_Animation_4_384"  # change if you want GOAL_Simple_384
PATH_TEMPLATE = "{league}"       # OUTDIR/<league>/...
PURGE_BEFORE  = "1"
NO_RENDER     = "0"
QUIT_APP      = "1"

# League-only
LEAGUE = "CFB"                   # use "CFB" to hit college rows too (NCAAF, NCAAF_*)

def _write_bridge_jsx(env):
    def esc(s): return s.replace("\\","\\\\").replace('"','\\"')
    lines = [ '$.setenv("'+esc(k)+'","'+esc(str(v))+'");' for k,v in env.items() ]
    lines.append('$.evalFile(File("'+esc(JSX_BATCH)+'"));')
    code = "\n".join(lines)+"\n"
    tmp = tempfile.NamedTemporaryFile(prefix="ae_bridge_", suffix=".jsx", delete=False)
    tmp.write(code.encode("utf-8")); tmp.flush(); tmp.close()
    return tmp.name

def run(env):
    os.makedirs(OUTDIR, exist_ok=True)
    bridge = _write_bridge_jsx(env)
    osa = [
        "osascript",
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to activate',
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to DoScriptFile POSIX file "{bridge}"',
    ]
    print("Running:", " ".join(shlex.quote(c) for c in osa))
    subprocess.run(osa, check=True)

def make_env():
    return {
        "AE_PROJECT": PROJECT,
        "AE_CSV": CSV_PATH,
        "AE_COMP": COMP,

        # Layer names for this comp
        "AE_SOLID_LAYER": "Solid",
        "AE_FG_TEXT_LAYER": "FIELD GOAL",
        "AE_FG_KICKER_LAYER": "FG-Kicker",

        # Logos (optional; keep if you have a logo layer in this comp)
        "AE_LOGO_LAYER": "TeamLogo",
        "AE_LOGO_DIR": "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Logos-Large",
        "AE_LOGO_PATH_TEMPLATE": "{league}/{abbr}",
        "AE_LOGO_EXTS": "png,jpg,jpeg,svg,ai,psd",

        # Output config (PNG sequence)
        "AE_OUTDIR": OUTDIR,
        "AE_PATH_TEMPLATE": PATH_TEMPLATE,
        "AE_ANIM": ANIM_NAME,
        "AE_RS_TEMPLATE": RS_TEMPLATE,
        "AE_OM_TEMPLATE": OM_TEMPLATE,

        "AE_PURGE_BEFORE_RENDER": PURGE_BEFORE,
        "AE_NO_RENDER": NO_RENDER,
        "AE_QUIT": QUIT_APP,

        # League-only
        "AE_LEAGUE": LEAGUE,
    }

if __name__ == "__main__":
    assert os.path.isfile(JSX_BATCH), f"JSX not found: {JSX_BATCH}"
    assert os.path.isfile(PROJECT),   f"Project not found: {PROJECT}"
    assert os.path.isfile(CSV_PATH),  f"CSV not found: {CSV_PATH}"
    run(make_env())
